// PageSettingCuster.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingTabScreen.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "DecCtrlClientTypes.h"

// CPageSettingTabScreen Ի

IMPLEMENT_DYNAMIC(CPageSettingTabScreen, CDialog)

CPageSettingTabScreen::CPageSettingTabScreen(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingTabScreen::IDD, pParent)
{

}

CPageSettingTabScreen::~CPageSettingTabScreen()
{
}

void CPageSettingTabScreen::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB6, m_TabCuster);
}


BEGIN_MESSAGE_MAP(CPageSettingTabScreen, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB6, &CPageSettingTabScreen::OnTcnSelchangeTab6)
END_MESSAGE_MAP()


// CPageSettingTabScreen Ϣ
int CPageSettingTabScreen::Initialize(LONG _lLogonID)
{
	if (_lLogonID < 0)
	{
		return -1;
	}
	m_lLogonID = _lLogonID;
	m_pageMultiScreen.SetLogonID(_lLogonID);
	m_pageScreenCtl.SetLogonID(_lLogonID);

	memset(&m_decParam,0,sizeof(m_decParam));
	DEC_ClientGetDecoderPara(_lLogonID,&m_decParam);

	m_pageMultiScreen.Initialize(&m_decParam);
	m_pageScreenCtl.Initialize(&m_decParam);

	return 0;
}
BOOL CPageSettingTabScreen::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_TabCuster.InsertItem(0, GetTextByLan("","Multi Screen Setting"));
	m_TabCuster.InsertItem(1, GetTextByLan("","Screen Ctrl Setting"));

	m_pageMultiScreen.Create(IDD_DIALOG_MULTI_SCREEN, &m_TabCuster);
	m_pageScreenCtl.Create(IDD_DIALOG_PAGE_SETTING_SCREENCTRL, &m_TabCuster);

	CRect rc;
	m_TabCuster.GetClientRect(rc);
	rc.top += 21;
	rc.bottom -= 5;
	rc.left += 3;
	rc.right -= 5;

	m_pageMultiScreen.MoveWindow(&rc);
	m_pageScreenCtl.MoveWindow(&rc);

	m_pDialog[0] = &m_pageMultiScreen;
	m_pDialog[1] = &m_pageScreenCtl;

	m_pDialog[0]->ShowWindow(SW_SHOW);
	m_pDialog[1]->ShowWindow(SW_HIDE);
	this->SetWindowText(GetText(IDS_SETTING_SET));
	//浱ǰѡ
	m_iCurSelTab = 0;
	return FALSE;
}


void CPageSettingTabScreen::OnTcnSelchangeTab6(NMHDR *pNMHDR, LRESULT *pResult)
{
	m_pDialog[m_iCurSelTab]->ShowWindow(SW_HIDE);
	m_iCurSelTab = m_TabCuster.GetCurSel();
	m_pDialog[m_iCurSelTab]->ShowWindow(SW_SHOW);
	*pResult = 0;
}

void CPageSettingTabScreen::OnMainNotify( _MAIN_NOTIFY_DATA* _pData )
{
	m_pageMultiScreen.OnMainNotify(_pData);
	m_pageScreenCtl.OnMainNotify(_pData);
}
void CPageSettingTabScreen::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	m_pageMultiScreen.OnParamChangeNotify(pData);
	m_pageScreenCtl.OnParamChangeNotify(pData);
}
